﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Notatnik.NET
{
    public partial class Form1 : Form
    {
        string ścieżkaPliku = "";
        bool tekstZmieniony = false;
        static string[] slowaKluczowe = { "if", "for" };
        static string[] wariacjeSlowa = { " ", "{" };

        int maxDl = okreslMaxDl(Form1.slowaKluczowe);
        public Form1()
        {
            InitializeComponent();
        }

        #region Metody pomocnicze
        private void ustalTytułOkna()
        {
            this.Text =
                Path.GetFileName(ścieżkaPliku) +
                (tekstZmieniony ? "*" : "") +
                " - Notatnik.NET";
        }

        private bool zapiszDoPlikuJako()
        {
            //if (!string.IsNullOrWhiteSpace(ścieżkaPliku))
            if (File.Exists(ścieżkaPliku))
            {
                saveFileDialog1.InitialDirectory = Path.GetDirectoryName(ścieżkaPliku);
                saveFileDialog1.FileName = Path.GetFileName(ścieżkaPliku);
            }
            else
            {
                saveFileDialog1.FileName = "";
            }
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                okno.ReadOnly = false;
                if (saveFileDialog1.FileName.EndsWith(".rtf"))
                {
                    okno.SaveFile(saveFileDialog1.FileName);
                }
                else
                {
                    File.WriteAllLines(saveFileDialog1.FileName, okno.Lines);
                }

                ścieżkaPliku = saveFileDialog1.FileName;
                tekstZmieniony = false;
                ustalTytułOkna();
                return true;
            }
            else return false;
        }

        private bool zapiszDoPliku()
        {
            try
            {
                if (!File.Exists(ścieżkaPliku)) return zapiszDoPlikuJako();
                else
                {
                    if (ścieżkaPliku.EndsWith(".rtf"))
                    {
                        okno.SaveFile(ścieżkaPliku);
                    }
                    else
                    {
                        File.WriteAllLines(ścieżkaPliku, okno.Lines);
                    }
                    tekstZmieniony = false;
                    ustalTytułOkna();
                    return true;
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd podczas zapisywania: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                return false;
            }
        }

        private bool spytajCzyZapisać()
        {
            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisać zmiany w pliku " + ścieżkaPliku + "?",
                this.Text,
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question);
            switch (dr)
            {
                case DialogResult.Yes:
                    return zapiszDoPliku();
                case DialogResult.No:
                    return true;
                case DialogResult.Cancel:
                    return false;
                default:
                    throw new Exception("Nieprzewidziana wartość zmiennej 'dr'");
            }
        }

        private void wyczyśćNotatnik()
        {
            okno.Text = "";
            ścieżkaPliku = "";
            tekstZmieniony = false;
            ustalTytułOkna();
        }
        #endregion

        #region Metody zdarzeniowe
        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.FileName = ścieżkaPliku;
                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    okno.ReadOnly = openFileDialog1.ReadOnlyChecked;
                    ścieżkaPliku = openFileDialog1.FileName;
                    tekstZmieniony = false;
                    if (ścieżkaPliku.EndsWith(".rtf"))
                        okno.LoadFile(openFileDialog1.FileName);
                    else
                        okno.Lines = File.ReadAllLines(openFileDialog1.FileName);
                    ustalTytułOkna();
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd odczytu pliku: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //zawartość przeniesiona do osobnej metody
            zapiszDoPlikuJako();
        }

        private void zmieńKolorTła(object sender, EventArgs e)
        {
            colorDialog1.Color = okno.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                okno.BackColor = colorDialog1.Color;
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = okno.Font;
            fontDialog1.Color = okno.ForeColor;
            if (fontDialog1.ShowDialog() == DialogResult.OK)
            {
                okno.SelectionFont = fontDialog1.Font;
                okno.SelectionColor = fontDialog1.Color;
            }
        }

        private void zawijanieWierszyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //zawijanieWierszyToolStripMenuItem.Checked = !zawijanieWierszyToolStripMenuItem.Checked;
            okno.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zapiszDoPliku();
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!tekstZmieniony) wyczyśćNotatnik();
            else if (spytajCzyZapisać()) wyczyśćNotatnik();
        }



        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!tekstZmieniony) Close();
            else if (spytajCzyZapisać()) Close();
        }
        #endregion
        Color zaznaczKolor = Color.Red;
        private IEnumerable<object> slowakluczowe;

        private void okno_TextChanged(object sender, EventArgs e)
        {
            tekstZmieniony = true;
            ustalTytułOkna();
            //int index = 0;
            int pozycja = okno.SelectionStart;
            Color kolor = okno.SelectionColor;
            //do
            //{
            int start = pozycja - maxDl;
            if (start < 0) start = 0;
            string szukaj;
            foreach (string slowoKluczowe in slowaKluczowe)
            {
                foreach (var wariacjaSlowa in wariacjeSlowa)
                {
                    szukaj = slowoKluczowe + wariacjaSlowa;
                    okno.Find(szukaj, start, pozycja, RichTextBoxFinds.WholeWord);
                    if (okno.SelectionLength > 0)
                    {
                        if (szukaj.EndsWith("{"))
                            szukaj = szukaj.TrimEnd('{');
                        okno.Find(szukaj, start, pozycja - 1, RichTextBoxFinds.WholeWord);
                        okno.SelectionColor = Color.Red;
                        okno.SelectionStart = pozycja;
                        okno.SelectionLength = 0;
                    }
                    okno.SelectionColor = kolor;
                }
            }
        }

        public static int okreslMaxDl(string[] slowaKluczowe)
        {
            int dlMax = 0;
            foreach (string item in slowaKluczowe)
            {
                if (item.Length > dlMax)
                    dlMax = item.Length + 5;
            }
            return dlMax;
        }


    }
}
